/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.util;

import java.util.Random;
import lykrast.defiledlands.common.util.Config;
import lykrast.defiledlands.common.util.CorruptionRecipes;
import lykrast.defiledlands.common.world.biome.BiomeDefiled;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class CorruptionHelper {
    public static void spread(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && CorruptionHelper.canSpread(worldIn, pos, rand)) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(5) - 2, rand.nextInt(5) - 2, rand.nextInt(5) - 2);
                if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos)) {
                    return;
                }
                IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                CorruptionHelper.corrupt(worldIn, blockpos, iblockstate1);
            }
        }
    }

    public static boolean canSpread(World worldIn, BlockPos pos, Random rand) {
        Biome biome = worldIn.func_180494_b(pos);
        return biome instanceof BiomeDefiled || !Config.confinedSpread;
    }

    public static boolean isCorruptable(IBlockState input) {
        return CorruptionRecipes.getCorrupted(input) != null;
    }

    public static boolean corrupt(World worldIn, BlockPos blockpos, IBlockState state) {
        IBlockState corrupted = CorruptionRecipes.getCorrupted(state);
        if (corrupted == null) {
            return false;
        }
        worldIn.func_175656_a(blockpos, corrupted);
        return true;
    }
}

